% ******************** transformation with conformal method ************************* %

% function output=transformation(joint 1 to 2 ,joint 2 to 1 ,points1 ,points2 ,save to)
% all inputs must be in '.txt'   for example: 'points1.txt'
% type of c1 (joint 1 to 2) & c2 (joint 2 to 1) : x y z   _ in 3 rows float number
% type of p1 (points1) & p2 (points2) : p x y z   _ in 4 rows     float number

% *********************************************************************************** %


function C=transformation(c1,c2,p1,p2,p12)
q=load(c2);
s=size(q);
g=load(c1);
for i=1:s(1)
    L(2*i-1,1)=g(i,1);
    L(2*i,1)=g(i,2);
    dh(i)=g(i,3)-q(i,3);
end

for i=1:s(1)
    A(2*i-1,:)=[q(i,1) -q(i,2) 1 0];
    A(2*i,:)=[q(i,2) q(i,1) 0 1 ];
end

X=inv(A'*A)*A'*L;
e1=load(p2);
e=e1(:,2:3);
c1=load(p1);
c=c1(:,2:3);
f=size(e);
for i=1:f(1)
   u(2*i-1,:)=[e(i,1) -e(i,2) 1 0];
    u(2*i,:)=[e(i,2) e(i,1) 0 1 ];
end
p1=u*X;
for i=1:f(1);
    p(i,1)=p1(2*i-1);
    p(i,2)=p1(2*i);
end
h=sum(dh)/length(dh);
p(:,3)=e1(:,4)+h*ones(f(1),1);
C=c1;
C(length(C)+1:length(C)+f(1),1)=e1(:,1);
C(length(C)+1-f(1):length(C),2:4)=p;

fid=fopen(p12,'wt');
for i=1:length(C)
    fprintf(fid,'%d',C(i,1));
    fprintf(fid,'%c\t','');
    for j=2:4
        fprintf(fid,'%f',C(i,j));
        fprintf(fid,'%c\t','');
    end
    fprintf(fid,'%c\n','');
end
fclose(fid);
end
